﻿using System.IO;
using System.Net;

class FtpGet
{
    static void Main(string[] args)
    {
        string ftpSource = "ftp://www.mysite.com/MyFile.txt";
        string fileName = "MyFile.txt";
        string userName = "nazwa użytkownika";
        string password = "hasło";

        FtpWebRequest downloadRequest =
            WebRequest.Create(ftpSource)
            as FtpWebRequest;

        downloadRequest.Credentials =
            new NetworkCredential(userName, password);

        FtpWebResponse downloadResponse =
            downloadRequest.GetResponse()
            as FtpWebResponse;
        using (var responseStream = downloadResponse.GetResponseStream())
        {

            if (fileName.Length == 0)
            {
                using (var reader = new StreamReader(responseStream))
                {
                    reader.ReadToEnd();
                }
            }
            else
            {
                using (FileStream fileStream = File.Create(fileName))
                {
                    const int BufferSize = 1024;

                    var buffer = new byte[BufferSize];
                    int bytesRead;
                    while (true)
                    {
                        bytesRead = responseStream.Read(buffer, 0, buffer.Length);
                        if (bytesRead == 0)
                            break;
                        fileStream.Write(buffer, 0, bytesRead);
                    }
                }
            }
        }
    }
}